@extends('layouts.layoutapp')

@section('content')
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-3 px-3">
                            <h4 class="mb-0">Invoice Profit Report</h4>

                            <form method="GET" action="{{ route('profit_report') }}" class="d-flex align-items-center">
                                <div class="form-group me-3">
                                    <input type="date" class="form-control @error('start_date') is-invalid @enderror"
                                        id="start_date" name="start_date"
                                        value="{{ old('start_date', request()->get('start_date')) }}">
                                    @error('start_date')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group me-3">
                                    <input type="date" class="form-control @error('end_date') is-invalid @enderror"
                                        id="end_date" name="end_date"
                                        value="{{ old('end_date', request()->get('end_date')) }}">
                                    @error('end_date')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <button type="submit" class="btn btn-primary">Filter</button>
                            </form>
                        </div>

                        <div class="mb-4">
                            <div class="table-responsive">
                                <table class="table text-center text-xs" id="myTable2">
                                    <thead>
                                        <tr>
                                            <th>Branch Name</th>
                                            <th>Invoice Id</th>
                                            <th>Invoice Date</th>
                                            <th>Total Selling Price</th>
                                            <th>Total Buying Price</th>
                                            <th>Total Profit</th>
                                            <th>Tax Amount</th>
                                            <th>Discount</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($profitDetails as $index => $detail)
                                            <tr>
                                                <td>{{$detail['branch_name']}}</td>
                                                <td>{{$detail['invoice_id']}}</td>
                                                <td>{{\Carbon\Carbon::parse($detail['invoice_date'])->format('d-m-Y')}}</td>
                                                <td>₹ {{ number_format(max($detail['total_selling_price'], 0), 2) }}</td>
                                                <td>₹ {{ number_format(max($detail['total_margin_price'], 0), 2) }}</td>
                                                <td>₹ {{ number_format(max($detail['total_profit'], 0), 2) }}</td>
                                                <td>₹ {{ number_format(max($detail['tax_amount'], 0), 2) }}</td>
                                                <td>₹ {{ number_format(max($detail['discount'], 0), 2) }}</td>
                                                <td>
                                                    <button data-bs-toggle="modal"
                                                        data-bs-target="#productDetailsModal{{ $index }}"
                                                        style="border:none;background:none">
                                                        <i class="fa fa-eye"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th colspan="3" class="text-end">Page Total:</th>
                                            <th id="page-total-selling" class="text-center">₹ 0.00</th>
                                            <th id="page-total-margin" class="text-center">₹ 0.00</th>
                                            <th id="page-total-profit" class="text-center">₹ 0.00</th>
                                            {{-- <th id="page-total-tax" class="text-center">₹ 0.00</th> --}}
                                            <th colspan="4"></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>


                            <!-- Product Details Modals -->
                            @foreach ($profitDetails as $index => $detail)
                                <div class="modal fade" id="productDetailsModal{{ $index }}" tabindex="-1"
                                    aria-labelledby="productDetailsModalLabel{{ $index }}" aria-hidden="true">
                                    <div class="modal-dialog modal-xl">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="productDetailsModalLabel{{ $index }}">Product Profit
                                                    Details
                                                    for Invoice: {{ $detail['invoice_id'] }}</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body table-responsive">
                                                <table class="table table-bordered text-center text-sm">
                                                    <thead>
                                                        <tr>
                                                            <th>Product Name</th>
                                                            <th class="text-wrap">Selling Price / Unit</th>
                                                            <th class="text-wrap">Buying Price / Unit</th>
                                                            <th>Quantity</th>
                                                            <th>Total Selling Price</th>
                                                            <th>Total Buying Price</th>
                                                            <th>Profit</th>
                                                            <th>Tax Amount</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach ($detail['product_profit_details'] as $product)
                                                            <tr>
                                                                <td>{{ $product['product_name'] }}</td>
                                                                <td>₹ {{ number_format($product['selling_price'], 2) }}</td>
                                                                <td>₹ {{ number_format($product['margin_price'], 2) }}</td>
                                                                <td>{{ number_format($product['quantity'], 2) }} </td>
                                                                <td>₹
                                                                    {{ number_format(($product['selling_price'] * $product['quantity']), 2) }}
                                                                </td>
                                                                <td>₹
                                                                    {{ number_format(($product['margin_price'] * $product['quantity']), 2) }}
                                                                </td>
                                                                <td>₹{{ number_format($product['profit'], 2) }}</td>
                                                                <td>₹ {{ number_format($product['tax_amount'], 2) }}</td>
                                                            </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary"
                                                    data-bs-dismiss="modal">Close</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        $(document).ready(function () {
            var table = $('#myTable2').DataTable({
                layout: {
                    topStart: {
                        buttons: ['excel', 'pdf', 'print', 'colvis', 'pageLength']
                    }
                },
                lengthMenu: [[10, 500, 1000, -1], [10, 500, 1000, "All"]],
                pageLength: 10,
            });

            function updatePageTotals() {
                var sellingTotal = 0;
                var marginTotal = 0;
                var profitTotal = 0;
                // var taxTotal = 0;

                var rows = table.rows({ page: 'current' }).nodes();

                $(rows).each(function () {
                    var sellingPrice = parseFloat($(this).find('td:eq(3)').text().replace(/[^\d.-]/g, '')) || 0;
                    var marginPrice = parseFloat($(this).find('td:eq(4)').text().replace(/[^\d.-]/g, '')) || 0;
                    var profit = parseFloat($(this).find('td:eq(5)').text().replace(/[^\d.-]/g, '')) || 0;
                    // var tax = parseFloat($(this).find('td:eq(5)').text().replace(/[^\d.-]/g, '')) || 0;

                    sellingTotal += sellingPrice;
                    marginTotal += marginPrice;
                    profitTotal += profit;
                    // taxTotal +=tax
                });

                $('#page-total-selling').html('₹ ' + Math.floor(sellingTotal).toFixed(2));
                $('#page-total-margin').html('₹ ' + Math.floor(marginTotal).toFixed(2));
                $('#page-total-profit').html('₹ ' + Math.floor(profitTotal).toFixed(2));
                // $('#page-total-tax').html('₹ ' + Math.floor(taxTotal).toFixed(2));

            }

            // Attach the updatePageTotals function to the draw event
            table.on('draw', function () {
                updatePageTotals();
            });

            // Attach the updatePageTotals function to the page event (for pagination)
            table.on('page', function () {
                updatePageTotals();
            });

            // Trigger the updatePageTotals function on page load
            updatePageTotals();
        });
    </script>

@endpush