<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QuotesModel extends Model
{
    use HasFactory;
    protected $table = 'quotes';
    protected $primaryKey = 'id';
    protected $fillable = [
        'quote_id',
        'client_id',
        'quote_date',
        'due_date',
        'amount',
        'final_amount',
        'discount_type',
        'discount',
        'note',
        'term',
        'branch_id',
        'template_id',
        'recurring',
        'status',
        'gst',
        'oprntl_flag'
    ];
    protected $dates = [
        'quote_date',
        'due_date',
        'created_at',
        'updated_at',
    ];
    public function client()
    {
        return $this->belongsTo(ClientModel::class);
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function quotesItem()
    {
        return $this->hasMany(QuotesItemsModel::class, 'quote_id', 'id');
    }
    public function branch()
    {
        return $this->belongsTo(BranchModel::class, 'branch_id');
    }

    const DRAFT = 3;

    const CONVERTED = 1;

    const STATUS_ALL = 2;

    const STATUS_ARR = [
        self::DRAFT => 'Draft',
        self::CONVERTED => 'Converted',
        self::STATUS_ALL => 'All',
    ];
}
