<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RightsDetailModel extends Model
{
    use HasFactory;
    
    protected $table= 'rights_dtl';
    protected $primary_key ='id';

    protected $fillable = [
        'rights_id',
        'menu_id'
    ];
    public function right()
    {
        return $this->belongsTo(RightsModel::class,'rights_id','id');
    }

    public function menu()
    {
        return $this->belongsTo(MenuModel::class, 'menu_id');
    }
}
