<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>EMO Print  Upload #<?php echo e($upload->id); ?></title>
    <style>
        /* ===== Choose your slip height ===== */
        
        /* Option A: 120mm slip */
        /* @page { size: 105mm 120mm portrait; margin: 5mm; }
        .page { height: 120mm; } */

        /* Option B: 127mm slip (standard 5 inch) */
        @page { size: 105mm 127mm portrait; margin: 5mm; }
        .page { height: 127mm; }

        /* Option C: 130mm slip */
        /* @page { size: 105mm 130mm portrait; margin: 5mm; }
        .page { height: 130mm; } */

        body {
            margin: 0;
            font-family: DejaVu Sans, Arial, sans-serif;
            font-size: 11pt;
            color: #000;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }

        .page {
            width: 105mm;
            margin: auto;
            page-break-after: always;
            text-align: center;
            display: flex;
            align-items: flex-start;
            justify-content: center;
        }

        .content {
            margin-top: 5mm;   /* Move text down slightly */
            line-height: 1.4;
            width: 100%;
        }

        .lbl { font-weight: bold; }
    </style>
</head>
<body onload="window.print()">

<?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="page">
        <div class="content">
            <div><?php echo e($r->sender_name); ?>,</div>
            <div>
                <?php if(!empty($r->sender_address1)): ?> <?php echo e($r->sender_address1); ?> <?php endif; ?>
                <?php if(!empty($r->sender_address2)): ?> , <?php echo e($r->sender_address2); ?> <?php endif; ?>
                <?php if(!empty($r->sender_address3)): ?> , <?php echo e($r->sender_address3); ?> <?php endif; ?>
                <?php if(!empty($r->sender_city)): ?> , <?php echo e($r->sender_city); ?> <?php endif; ?>
                - <?php echo e($r->sender_pincode); ?>

                <?php if(!empty($r->sender_mobile)): ?> , <?php echo e($r->sender_mobile); ?> <?php endif; ?>
            </div>

            <br> <br> <br>



            <div><span class="lbl">EMO No:</span> <?php echo e($r->emo_number); ?></div>
            <div><span class="lbl">Received Rs.</span> <?php echo e(number_format($r->emo_amount, 2)); ?> 
                (<?php echo e(\App\Helpers\NumberHelper::convertToIndianCurrency($r->emo_amount)); ?>)
            </div>
            <div><span class="lbl">Dated:</span> <?php echo e(now()->format('d/m/Y')); ?></div>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</body>
</html>
<?php /**PATH /opt/lampp/htdocs/lara_postoffice/resources/views/emo/print.blade.php ENDPATH**/ ?>